<?php
header('Content-Type: application/json');

// Database connection
$host = 'localhost:3306';
$dbname = 'tawasoll_book';
$username = 'root';
$password = '';

try {
    $pdo = new PDO("mysql:host=$host;dbname=$dbname;charset=utf8mb4", $username, $password);
    $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
} catch(PDOException $e) {
    echo json_encode(['success' => false, 'message' => $e->getMessage()]);
    exit;
}

if (!isset($_GET['id'])) {
    echo json_encode(['success' => false, 'message' => 'No transaction ID provided']);
    exit;
}

$id = $_GET['id'];

$query = "SELECT t.*, c.name as customer_name, c.business_type
          FROM transactions t
          LEFT JOIN customer_context c ON t.customer_phone = c.customer_phone
          WHERE t.id = :id";

$stmt = $pdo->prepare($query);
$stmt->execute([':id' => $id]);
$transaction = $stmt->fetch(PDO::FETCH_ASSOC);

if ($transaction) {
    echo json_encode(['success' => true, 'transaction' => $transaction]);
} else {
    echo json_encode(['success' => false, 'message' => 'Transaction not found']);
}
?>
